/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageItemInventory;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageManager;
import fr.iglee42.evolvedmekanism.registries.EMLootFunctions;
import java.util.List;
import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.tile.TileEntityPersonalStorage;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class PersonalTieredStorageContentsLootFunction
implements LootItemFunction {
    private static final PersonalTieredStorageContentsLootFunction INSTANCE = new PersonalTieredStorageContentsLootFunction();
    private static final Set<LootContextParam<?>> REFERENCED_PARAMS = Set.of(LootContextParams.f_81462_);

    private PersonalTieredStorageContentsLootFunction() {
    }

    public static LootItemFunction.Builder builder() {
        return () -> INSTANCE;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)EMLootFunctions.TIERED_PERSONAL_STORAGE_LOOT_FUNC.get();
    }

    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        TileEntityPersonalStorage personalStorage;
        BlockEntity blockEntity = (BlockEntity)lootContext.m_165124_(LootContextParams.f_81462_);
        if (blockEntity instanceof TileEntityPersonalStorage && !(personalStorage = (TileEntityPersonalStorage)blockEntity).isInventoryEmpty()) {
            List tileSlots = personalStorage.getInventorySlots(null);
            TieredPersonalStorageItemInventory destInv = TieredPersonalStorageManager.getInventoryFor(itemStack);
            for (int i = 0; i < tileSlots.size(); ++i) {
                IInventorySlot tileSlot = (IInventorySlot)tileSlots.get(i);
                if (tileSlot.isEmpty()) continue;
                destInv.setStackInSlot(i, tileSlot.getStack().m_41777_());
            }
        }
        return itemStack;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return REFERENCED_PARAMS;
    }

    public static class PersonalStorageLootFunctionSerializer
    implements Serializer<PersonalTieredStorageContentsLootFunction> {
        public void serialize(JsonObject pJson, PersonalTieredStorageContentsLootFunction pValue, JsonSerializationContext pSerializationContext) {
        }

        public PersonalTieredStorageContentsLootFunction deserialize(JsonObject pJson, JsonDeserializationContext pSerializationContext) {
            return INSTANCE;
        }
    }
}

